/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.core.registry;

import com.minecraftabnormals.neapolitan.common.block.StrawberryBushBlock;
import com.minecraftabnormals.neapolitan.common.world.gen.feature.AdzukiPatchFeature;
import com.minecraftabnormals.neapolitan.common.world.gen.feature.BananaPlantFeature;
import com.minecraftabnormals.neapolitan.common.world.gen.feature.MintPondFeature;
import com.minecraftabnormals.neapolitan.common.world.gen.feature.StrawberryPatchFeature;
import com.minecraftabnormals.neapolitan.common.world.gen.feature.VanillaPatchFeature;
import com.minecraftabnormals.neapolitan.core.NeapolitanConfig;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class NeapolitanFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"neapolitan");
    public static final RegistryObject<Feature<BlockClusterFeatureConfig>> STRAWBERRY_PATCH = FEATURES.register("strawberry_patch", () -> new StrawberryPatchFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_));
    public static final RegistryObject<Feature<BlockClusterFeatureConfig>> VANILLA_VINE_PATCH = FEATURES.register("vanilla_patch", () -> new VanillaPatchFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> BANANA_PLANT = FEATURES.register("banana_plant", () -> new BananaPlantFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<BlockClusterFeatureConfig>> ADZUKI_PATCH = FEATURES.register("adzuki_patch", () -> new AdzukiPatchFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> MINT_POND = FEATURES.register("mind_pond", () -> new MintPondFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> PATCH_STRAWBERRY_BUSH = (ConfiguredFeature)((Feature)STRAWBERRY_PATCH.get()).func_225566_b_((IFeatureConfig)Configs.STRAWBERRY_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(((Integer)NeapolitanConfig.COMMON.strawberryBushGenerationChance.get()).intValue());
        public static final ConfiguredFeature<?, ?> PATCH_VANILLA_VINE = (ConfiguredFeature)((Feature)VANILLA_VINE_PATCH.get()).func_225566_b_((IFeatureConfig)Configs.VANILLA_VINE_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(((Integer)NeapolitanConfig.COMMON.vanillaVineGenerationChance.get()).intValue());
        public static final ConfiguredFeature<?, ?> PATCH_ADZUKI_SPROUTS = (ConfiguredFeature)((Feature)ADZUKI_PATCH.get()).func_225566_b_((IFeatureConfig)Configs.ADZUKI_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(((Integer)NeapolitanConfig.COMMON.adzukiSproutsGenerationChance.get()).intValue());
        public static final ConfiguredFeature<?, ?> MINT_POND = (ConfiguredFeature)((Feature)MINT_POND.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l).func_242729_a(((Integer)NeapolitanConfig.COMMON.mintPondGenerationChance.get()).intValue());
        public static final ConfiguredFeature<?, ?> BANANA_PLANT = ((Feature)BANANA_PLANT.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Features.Placements.field_244001_l);
        public static final ConfiguredFeature<?, ?> BANANA_PLANT_BEACH = BANANA_PLANT.func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.075f, 1)));
        public static final ConfiguredFeature<?, ?> BANANA_PLANT_JUNGLE = BANANA_PLANT.func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.3f, 3)));
        public static final ConfiguredFeature<?, ?> BANANA_PLANT_RARE = BANANA_PLANT.func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.25f, 1)));
        public static final ConfiguredFeature<?, ?> BANANA_PLANT_VERY_RARE = BANANA_PLANT.func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.15f, 1)));

        private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("neapolitan", name), configuredFeature);
        }

        public static void registerConfiguredFeatures() {
            Configured.register("patch_strawberry_bush", PATCH_STRAWBERRY_BUSH);
            Configured.register("patch_vanilla_vine", PATCH_VANILLA_VINE);
            Configured.register("patch_adzuki_sprouts", PATCH_ADZUKI_SPROUTS);
            Configured.register("mint_pond", MINT_POND);
            Configured.register("banana_plant", BANANA_PLANT);
            Configured.register("banana_plant_beach", BANANA_PLANT_BEACH);
            Configured.register("banana_plant_jungle", BANANA_PLANT_JUNGLE);
            Configured.register("banana_plant_rare", BANANA_PLANT_RARE);
            Configured.register("banana_plant_very_rare", BANANA_PLANT_VERY_RARE);
        }
    }

    public static final class Configs {
        public static final BlockClusterFeatureConfig STRAWBERRY_PATCH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)((Block)NeapolitanBlocks.STRAWBERRY_BUSH.get()).func_176223_P().func_206870_a(StrawberryBushBlock.TYPE, (Comparable)((Object)StrawberryBushBlock.StrawberryType.RED))), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227314_a_().func_227318_b_(5).func_227323_d_(5).func_227317_b_().func_227315_a_(512).func_227322_d_();
        public static final BlockClusterFeatureConfig VANILLA_VINE_PATCH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)NeapolitanBlocks.VANILLA_VINE.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227317_b_().func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig ADZUKI_PATCH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)NeapolitanBlocks.ADZUKI_SPROUTS.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227314_a_().func_227318_b_(3).func_227321_c_(2).func_227323_d_(3).func_227317_b_().func_227315_a_(256).func_227322_d_();
    }
}

